Index: bgpd/bgpd.h
===================================================================
RCS file: /home/cvs/private/hrs/openbgpd/bgpd/bgpd.h,v
retrieving revision 1.1.1.1
retrieving revision 1.5
diff -u -p -r1.1.1.1 -r1.5
--- bgpd/bgpd.h	30 Jun 2009 05:46:15 -0000	1.1.1.1
+++ bgpd/bgpd.h	9 Jul 2009 17:22:14 -0000	1.5
@@ -1,4 +1,4 @@
-/*	$OpenBSD: bgpd.h,v 1.222 2008/01/23 08:11:32 claudio Exp $ */
+/*	$OpenBSD: bgpd.h,v 1.241 2009/06/12 16:42:53 claudio Exp $ */
 
 /*
  * Copyright (c) 2003, 2004 Henning Brauer <henning@openbsd.org>
@@ -27,12 +27,19 @@
 #include <net/if.h>
 #include <net/pfkeyv2.h>
 
+#if defined(__FreeBSD__)	/* compat */
+#include "openbsd-compat.h"
+#endif /* defined(__FreeBSD__) */
+
 #include <poll.h>
 #include <stdarg.h>
+#include <imsg.h>
 
 #define	BGP_VERSION			4
 #define	BGP_PORT			179
+#ifndef CONFFILE
 #define	CONFFILE			"/etc/bgpd.conf"
+#endif /* !CONFFILE */
 #define	BGPD_USER			"_bgpd"
 #define	PEER_DESCR_LEN			32
 #define	PFTABLE_LEN			16
@@ -40,6 +47,8 @@
 #define	IPSEC_ENC_KEY_LEN		32
 #define	IPSEC_AUTH_KEY_LEN		20
 
+#define	ASNUM_MAX			0xffffffff
+
 #define	MAX_PKTSIZE			4096
 #define	MIN_HOLDTIME			3
 #define	READ_BUF_SIZE			65535
@@ -85,8 +94,8 @@
 
 /*
  * Limit the number of control messages generated by the RDE and queued in
- * session enigine. The RDE limit defines how many imsg are generated in
- * on poll round. The if the SE limit is hit the RDE control socket will no
+ * session engine. The RDE limit defines how many imsg are generated in
+ * one poll round. Then if the SE limit is hit the RDE control socket will no
  * longer be polled.
  */
 #define RDE_RUNNER_ROUNDS	100
@@ -105,21 +114,6 @@ enum reconf_action {
 	RECONF_DELETE
 };
 
-struct buf {
-	TAILQ_ENTRY(buf)	 entry;
-	u_char			*buf;
-	size_t			 size;
-	size_t			 wpos;
-	size_t			 rpos;
-	int			 fd;
-};
-
-struct msgbuf {
-	TAILQ_HEAD(, buf)	 bufs;
-	u_int32_t		 queued;
-	int			 fd;
-};
-
 struct bgpd_addr {
 	sa_family_t	af;
 	union {
@@ -169,12 +163,7 @@ struct bgpd_config {
 	u_int16_t				 short_as;
 	u_int16_t				 holdtime;
 	u_int16_t				 min_holdtime;
-};
-
-struct buf_read {
-	u_char			 buf[READ_BUF_SIZE];
-	u_char			*rptr;
-	size_t			 wpos;
+	u_int16_t				 connectretry;
 };
 
 enum announce_type {
@@ -235,11 +224,13 @@ struct peer_config {
 	struct capabilities	 capabilities;
 	char			 group[PEER_DESCR_LEN];
 	char			 descr[PEER_DESCR_LEN];
+	char			 rib[PEER_DESCR_LEN];
 	char			 if_depend[IFNAMSIZ];
 	char			 demote_group[IFNAMSIZ];
 	u_int32_t		 id;
 	u_int32_t		 groupid;
 	u_int32_t		 remote_as;
+	u_int32_t		 local_as;
 	u_int32_t		 max_prefix;
 	enum announce_type	 announce_type;
 	enum enforce_as		 enforce_as;
@@ -247,6 +238,7 @@ struct peer_config {
 	u_int16_t		 max_prefix_restart;
 	u_int16_t		 holdtime;
 	u_int16_t		 min_holdtime;
+	u_int16_t		 local_short_as;
 	u_int8_t		 template;
 	u_int8_t		 remote_masklen;
 	u_int8_t		 cloned;
@@ -259,8 +251,13 @@ struct peer_config {
 	u_int8_t		 softreconfig_in;
 	u_int8_t		 softreconfig_out;
 	u_int8_t		 ttlsec;	/* TTL security hack */
+	u_int8_t		 flags;
+	u_int8_t		 pad[3];
+	char			 lliface[IFNAMSIZ];
 };
 
+#define PEERFLAG_TRANS_AS	0x01
+
 struct network_config {
 	struct bgpd_addr	prefix;
 	struct filter_set_head	attrset;
@@ -274,54 +271,8 @@ struct network {
 	TAILQ_ENTRY(network)	entry;
 };
 
-/* ipc messages */
-
-#define	IMSG_HEADER_SIZE	sizeof(struct imsg_hdr)
-#define	MAX_IMSGSIZE		8192
-
-struct imsg_fd {
-	TAILQ_ENTRY(imsg_fd)	entry;
-	int			fd;
-};
-
-struct imsgbuf {
-	TAILQ_HEAD(fds, imsg_fd)	fds;
-	struct buf_read			r;
-	struct msgbuf			w;
-	int				fd;
-	pid_t				pid;
-};
-
 enum imsg_type {
 	IMSG_NONE,
-	IMSG_RECONF_CONF,
-	IMSG_RECONF_PEER,
-	IMSG_RECONF_FILTER,
-	IMSG_RECONF_LISTENER,
-	IMSG_RECONF_DONE,
-	IMSG_UPDATE,
-	IMSG_UPDATE_ERR,
-	IMSG_SESSION_ADD,
-	IMSG_SESSION_UP,
-	IMSG_SESSION_DOWN,
-	IMSG_MRT_OPEN,
-	IMSG_MRT_REOPEN,
-	IMSG_MRT_CLOSE,
-	IMSG_KROUTE_CHANGE,
-	IMSG_KROUTE_DELETE,
-	IMSG_KROUTE6_CHANGE,
-	IMSG_KROUTE6_DELETE,
-	IMSG_NEXTHOP_ADD,
-	IMSG_NEXTHOP_REMOVE,
-	IMSG_NEXTHOP_UPDATE,
-	IMSG_PFTABLE_ADD,
-	IMSG_PFTABLE_REMOVE,
-	IMSG_PFTABLE_COMMIT,
-	IMSG_NETWORK_ADD,
-	IMSG_NETWORK_REMOVE,
-	IMSG_NETWORK_FLUSH,
-	IMSG_NETWORK_DONE,
-	IMSG_FILTER_SET,
 	IMSG_CTL_END,
 	IMSG_CTL_RELOAD,
 	IMSG_CTL_FIB_COUPLE,
@@ -347,23 +298,40 @@ enum imsg_type {
 	IMSG_CTL_SHOW_RIB_MEM,
 	IMSG_CTL_SHOW_TERSE,
 	IMSG_CTL_SHOW_TIMER,
+	IMSG_NETWORK_ADD,
+	IMSG_NETWORK_REMOVE,
+	IMSG_NETWORK_FLUSH,
+	IMSG_NETWORK_DONE,
+	IMSG_FILTER_SET,
+	IMSG_RECONF_CONF,
+	IMSG_RECONF_RIB,
+	IMSG_RECONF_PEER,
+	IMSG_RECONF_FILTER,
+	IMSG_RECONF_LISTENER,
+	IMSG_RECONF_DONE,
+	IMSG_UPDATE,
+	IMSG_UPDATE_ERR,
+	IMSG_SESSION_ADD,
+	IMSG_SESSION_UP,
+	IMSG_SESSION_DOWN,
+	IMSG_MRT_OPEN,
+	IMSG_MRT_REOPEN,
+	IMSG_MRT_CLOSE,
+	IMSG_KROUTE_CHANGE,
+	IMSG_KROUTE_DELETE,
+	IMSG_KROUTE6_CHANGE,
+	IMSG_KROUTE6_DELETE,
+	IMSG_NEXTHOP_ADD,
+	IMSG_NEXTHOP_REMOVE,
+	IMSG_NEXTHOP_UPDATE,
+	IMSG_PFTABLE_ADD,
+	IMSG_PFTABLE_REMOVE,
+	IMSG_PFTABLE_COMMIT,
 	IMSG_REFRESH,
 	IMSG_IFINFO,
 	IMSG_DEMOTE
 };
 
-struct imsg_hdr {
-	u_int32_t	peerid;
-	pid_t		pid;
-	enum imsg_type	type;
-	u_int16_t	len;
-};
-
-struct imsg {
-	struct imsg_hdr	 hdr;
-	void		*data;
-};
-
 struct demote_msg {
 	char		 demote_group[IFNAMSIZ];
 	int		 level;
@@ -424,6 +392,7 @@ struct kroute {
 	u_int16_t	labelid;
 	u_short		ifindex;
 	u_int8_t	prefixlen;
+	u_int8_t	priority;
 };
 
 struct kroute6 {
@@ -433,6 +402,7 @@ struct kroute6 {
 	u_int16_t	labelid;
 	u_short		ifindex;
 	u_int8_t	prefixlen;
+	u_int8_t	priority;
 };
 
 struct kroute_nexthop {
@@ -510,7 +480,7 @@ struct ctl_show_rib {
 	u_int32_t		med;
 	u_int32_t		prefix_cnt;
 	u_int32_t		active_cnt;
-	u_int32_t		adjrib_cnt;
+	u_int32_t		rib_cnt;
 	u_int16_t		aspath_len;
 	u_int16_t		flags;
 	u_int8_t		prefixlen;
@@ -545,6 +515,7 @@ struct filter_community {
 };
 
 struct ctl_show_rib_request {
+	char			rib[PEER_DESCR_LEN];
 	struct ctl_neighbor	neighbor;
 	struct bgpd_addr	prefix;
 	struct filter_as	as;
@@ -590,6 +561,7 @@ enum comp_ops {
 struct filter_peers {
 	u_int32_t	peerid;
 	u_int32_t	groupid;
+	u_int16_t	ribid;
 };
 
 /* special community type */
@@ -644,6 +616,7 @@ TAILQ_HEAD(filter_head, filter_rule);
 
 struct filter_rule {
 	TAILQ_ENTRY(filter_rule)	entry;
+	char				rib[PEER_DESCR_LEN];
 	struct filter_peers		peer;
 	struct filter_match		match;
 	struct filter_set_head		set;
@@ -697,6 +670,7 @@ struct rrefresh {
 struct rde_memstats {
 	int64_t		path_cnt;
 	int64_t		prefix_cnt;
+	int64_t		rib_cnt;
 	int64_t		pt4_cnt;
 	int64_t		pt6_cnt;
 	int64_t		nexthop_cnt;
@@ -709,6 +683,15 @@ struct rde_memstats {
 	int64_t		attr_dcnt;
 };
 
+struct rde_rib {
+	SIMPLEQ_ENTRY(rde_rib)	entry;
+	char			name[PEER_DESCR_LEN];
+	u_int16_t		id;
+	u_int16_t		flags;
+};
+SIMPLEQ_HEAD(rib_names, rde_rib);
+extern struct rib_names ribnames;
+
 /* Address Family Numbers as per RFC 1700 */
 #define	AFI_IPv4	1
 #define	AFI_IPv6	2
@@ -723,6 +706,18 @@ struct rde_memstats {
 /* 4-byte magic AS number */
 #define AS_TRANS	23456
 
+/* macros for IPv6 link-local address */
+#if defined(__KAME__) && defined(IPV6_LINKLOCAL_PEER)
+#define IN6_LINKLOCAL_IFINDEX(addr) \
+        ((addr).s6_addr[2] << 8 | (addr).s6_addr[3])
+
+#define SET_IN6_LINKLOCAL_IFINDEX(addr, index) \
+        do { \
+                (addr).s6_addr[2] = ((index) >> 8) & 0xff; \
+                (addr).s6_addr[3] = (index) & 0xff; \
+        } while (0)
+#endif
+
 /* prototypes */
 /* bgpd.c */
 void		 send_nexthop_update(struct kroute_nexthop *);
@@ -730,18 +725,6 @@ void		 send_imsg_session(int, pid_t, voi
 int		 bgpd_redistribute(int, struct kroute *, struct kroute6 *);
 int		 bgpd_filternexthop(struct kroute *, struct kroute6 *);
 
-/* buffer.c */
-struct buf	*buf_open(size_t);
-struct buf	*buf_grow(struct buf *, size_t);
-int		 buf_add(struct buf *, const void *, size_t);
-void		*buf_reserve(struct buf *, size_t);
-int		 buf_close(struct msgbuf *, struct buf *);
-int		 buf_write(int, struct buf *);
-void		 buf_free(struct buf *);
-void		 msgbuf_init(struct msgbuf *);
-void		 msgbuf_clear(struct msgbuf *);
-int		 msgbuf_write(struct msgbuf *);
-
 /* log.c */
 void		 log_init(int);
 void		 vlog(int, const char *, va_list);
@@ -760,19 +743,6 @@ int	 cmdline_symset(char *);
 /* config.c */
 int	 host(const char *, struct bgpd_addr *, u_int8_t *);
 
-/* imsg.c */
-void	 imsg_init(struct imsgbuf *, int);
-int	 imsg_read(struct imsgbuf *);
-int	 imsg_get(struct imsgbuf *, struct imsg *);
-int	 imsg_compose(struct imsgbuf *, enum imsg_type, u_int32_t, pid_t, int,
-	    const void *, u_int16_t);
-struct buf	*imsg_create(struct imsgbuf *, enum imsg_type, u_int32_t, pid_t,
-		    u_int16_t);
-int	 imsg_add(struct buf *, const void *, u_int16_t);
-int	 imsg_close(struct imsgbuf *, struct buf *);
-void	 imsg_free(struct imsg *);
-int	 imsg_get_fd(struct imsgbuf *);
-
 /* kroute.c */
 int		 kr_init(int, u_int);
 int		 kr_change(struct kroute_label *);
@@ -788,10 +758,7 @@ void		 kr_nexthop_delete(struct bgpd_add
 void		 kr_show_route(struct imsg *);
 void		 kr_ifinfo(char *);
 int		 kr_reload(void);
-in_addr_t	 prefixlen2mask(u_int8_t);
 struct in6_addr	*prefixlen2mask6(u_int8_t prefixlen);
-void		 inet6applymask(struct in6_addr *, const struct in6_addr *,
-		    int);
 
 /* control.c */
 void	control_cleanup(const char *);
@@ -806,6 +773,10 @@ int	pftable_addr_remove(struct pftable_m
 int	pftable_commit(void);
 
 /* name2id.c */
+u_int16_t	 rib_name2id(const char *);
+const char	*rib_id2name(u_int16_t);
+void		 rib_unref(u_int16_t);
+void		 rib_ref(u_int16_t);
 u_int16_t	 rtlabel_name2id(const char *);
 const char	*rtlabel_id2name(u_int16_t);
 void		 rtlabel_unref(u_int16_t);
@@ -829,5 +800,8 @@ const char	*log_as(u_int32_t);
 int		 aspath_snprint(char *, size_t, void *, u_int16_t);
 int		 aspath_asprint(char **, void *, u_int16_t);
 size_t		 aspath_strlen(void *, u_int16_t);
+in_addr_t	 prefixlen2mask(u_int8_t);
+void		 inet6applymask(struct in6_addr *, const struct in6_addr *,
+		    int);
 
 #endif /* __BGPD_H__ */
