Index: bgpd/imsg.h
===================================================================
RCS file: bgpd/imsg.h
diff -N bgpd/imsg.h
--- /dev/null	1 Jan 1970 00:00:00 -0000
+++ bgpd/imsg.h	9 Jul 2009 16:49:54 -0000	1.1.1.1
@@ -0,0 +1,108 @@
+/*	$OpenBSD: imsg.h,v 1.3 2009/06/07 05:56:24 eric Exp $	*/
+
+/*
+ * Copyright (c) 2006, 2007 Pierre-Yves Ritschard <pyr@openbsd.org>
+ * Copyright (c) 2006, 2007, 2008 Reyk Floeter <reyk@openbsd.org>
+ * Copyright (c) 2003, 2004 Henning Brauer <henning@openbsd.org>
+ *
+ * Permission to use, copy, modify, and distribute this software for any
+ * purpose with or without fee is hereby granted, provided that the above
+ * copyright notice and this permission notice appear in all copies.
+ *
+ * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
+ * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
+ * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
+ * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
+ * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
+ * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
+ * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
+ */
+
+#include <sys/tree.h>
+
+#define READ_BUF_SIZE		65535
+#define IMSG_HEADER_SIZE	sizeof(struct imsg_hdr)
+#define MAX_IMSGSIZE		16384
+
+struct buf {
+	TAILQ_ENTRY(buf)	 entry;
+	u_char			*buf;
+	size_t			 size;
+	size_t			 max;
+	size_t			 wpos;
+	size_t			 rpos;
+	int			 fd;
+};
+
+struct msgbuf {
+	TAILQ_HEAD(, buf)	 bufs;
+	u_int32_t		 queued;
+	int			 fd;
+};
+
+struct buf_read {
+	u_char			 buf[READ_BUF_SIZE];
+	u_char			*rptr;
+	size_t			 wpos;
+};
+
+struct imsg_fd {
+	TAILQ_ENTRY(imsg_fd)	entry;
+	int			fd;
+};
+
+struct imsgbuf {
+	TAILQ_HEAD(, imsg_fd)	 fds;
+	struct buf_read		 r;
+	struct msgbuf		 w;
+	int			 fd;
+	pid_t			 pid;
+};
+
+#define IMSGF_HASFD	1
+
+struct imsg_hdr {
+	u_int32_t	 type;
+	u_int16_t	 len;
+	u_int16_t	 flags;
+	u_int32_t	 peerid;
+	u_int32_t	 pid;
+};
+
+struct imsg {
+	struct imsg_hdr	 hdr;
+	int		 fd;
+	void		*data;
+};
+
+
+/* buffer.c */
+struct buf	*buf_open(size_t);
+struct buf	*buf_dynamic(size_t, size_t);
+int		 buf_add(struct buf *, const void *, size_t);
+void		*buf_reserve(struct buf *, size_t);
+void		*buf_seek(struct buf *, size_t, size_t);
+size_t		 buf_size(struct buf *);
+size_t		 buf_left(struct buf *);
+void		 buf_close(struct msgbuf *, struct buf *);
+int		 buf_write(struct msgbuf *);
+void		 buf_free(struct buf *);
+void		 msgbuf_init(struct msgbuf *);
+void		 msgbuf_clear(struct msgbuf *);
+int		 msgbuf_write(struct msgbuf *);
+
+/* imsg.c */
+void	 imsg_init(struct imsgbuf *, int);
+ssize_t	 imsg_read(struct imsgbuf *);
+ssize_t	 imsg_get(struct imsgbuf *, struct imsg *);
+int	 imsg_compose(struct imsgbuf *, u_int32_t, u_int32_t, pid_t,
+	    int, void *, u_int16_t);
+int	 imsg_composev(struct imsgbuf *, u_int32_t, u_int32_t,  pid_t,
+	    int, const struct iovec *, int);
+struct buf *imsg_create(struct imsgbuf *, u_int32_t, u_int32_t, pid_t,
+	    u_int16_t);
+int	 imsg_add(struct buf *, void *, u_int16_t);
+void	 imsg_close(struct imsgbuf *, struct buf *);
+void	 imsg_free(struct imsg *);
+int	 imsg_flush(struct imsgbuf *);
+void	 imsg_clear(struct imsgbuf *);
