--- cpp.orig/include/Ice/Stream.h	2011-06-15 21:43:58.000000000 +0200
+++ cpp/include/Ice/Stream.h	2012-03-04 20:14:52.000000000 +0100
@@ -17,6 +17,12 @@
 #include <Ice/Proxy.h>
 #include <IceUtil/Shared.h>
 
+namespace IceInternal
+{
+    // Forward declaration required for writer specializations.
+    void delegateThrowMarshalException(const char*, int, const ::std::string&);
+}
+
 namespace Ice
 {
     
@@ -45,9 +51,6 @@
     StreamTraitTypeUnknown
 };
 
-// Forward declaration required for writer specializations.
-class MarshalException;
-
 //
 // Base trait template. This doesn't actually do anything -- we just
 // use it as a template that we can specialize.
@@ -542,7 +545,7 @@
     {
         if(static_cast<int>(v) < 0 || static_cast<int>(v) >= StreamTrait<T>::enumLimit)
         {
-            throw MarshalException(__FILE__, __LINE__, "enumerator out of range");
+            IceInternal::delegateThrowMarshalException(__FILE__, __LINE__, "enumerator out of range");
         }
         outS->write(static_cast<Byte>(v));
     }
@@ -558,7 +561,7 @@
         inS->read(val);
         if(val > StreamTrait<T>::enumLimit)
         {
-            throw MarshalException(__FILE__, __LINE__, "enumerator out of range");
+            IceInternal::delegateThrowMarshalException(__FILE__, __LINE__, "enumerator out of range");
         }
         v = static_cast<T>(val);
     }
@@ -573,7 +576,7 @@
     {
         if(static_cast<int>(v) < 0 || static_cast<int>(v) >= StreamTrait<T>::enumLimit)
         {
-            throw MarshalException(__FILE__, __LINE__, "enumerator out of range");
+            IceInternal::delegateThrowMarshalException(__FILE__, __LINE__, "enumerator out of range");
         }
         outS->write(static_cast<Short>(v));
     }
@@ -589,7 +592,7 @@
         inS->read(val);
         if(val < 0 || val > StreamTrait<T>::enumLimit)
         {
-            throw MarshalException(__FILE__, __LINE__, "enumerator out of range");
+            IceInternal::delegateThrowMarshalException(__FILE__, __LINE__, "enumerator out of range");
         }
         v = static_cast<T>(val);
     }
@@ -603,7 +606,7 @@
     {
         if(static_cast<int>(v) < 0 || static_cast<int>(v) >= StreamTrait<T>::enumLimit)
         {
-            throw MarshalException(__FILE__, __LINE__, "enumerator out of range");
+            IceInternal::delegateThrowMarshalException(__FILE__, __LINE__, "enumerator out of range");
         }
         outS->write(static_cast<Int>(v));
     }
@@ -619,7 +622,7 @@
         inS->read(val);
         if(val < 0 || val > StreamTrait<T>::enumLimit)
         {
-            throw MarshalException(__FILE__, __LINE__, "enumerator out of range");
+            IceInternal::delegateThrowMarshalException(__FILE__, __LINE__, "enumerator out of range");
         }
         v = static_cast<T>(val);
     }
