--- cpp.orig/src/IceGrid/DescriptorHelper.cpp	2011-06-15 21:43:59.000000000 +0200
+++ cpp/src/IceGrid/DescriptorHelper.cpp	2012-03-04 20:14:53.000000000 +0100
@@ -198,15 +198,6 @@
     return result;
 }
 
-template<typename Dict> Dict
-getDictUpdatedElts(const Dict& ldict, const Dict& rdict)
-{
-#if defined(_MSC_VER) && (_MSC_VER < 1300)
-    return getDictUpdatedEltsWithEq(ldict, rdict, equal_to<Dict::mapped_type>());
-#else
-    return getDictUpdatedEltsWithEq(ldict, rdict, equal_to<typename Dict::mapped_type>());
-#endif
-}
 
 template<typename EqFunc, typename Dict> Dict
 getDictUpdatedEltsWithEq(const Dict& ldict, const Dict& rdict, EqFunc eq)
@@ -223,6 +214,16 @@
     return result;
 }
 
+template<typename Dict> Dict
+getDictUpdatedElts(const Dict& ldict, const Dict& rdict)
+{
+#if defined(_MSC_VER) && (_MSC_VER < 1300)
+    return getDictUpdatedEltsWithEq(ldict, rdict, equal_to<Dict::mapped_type>());
+#else
+    return getDictUpdatedEltsWithEq(ldict, rdict, equal_to<typename Dict::mapped_type>());
+#endif
+}
+
 template <typename Dict> Ice::StringSeq
 getDictRemovedElts(const Dict& ldict, const Dict& rdict)
 {
