# $FreeBSD: ports/devel/pear/bsd.pear.channel.mk,v 1.2 2011/07/11 09:36:59 mm Exp $
#
# Common code for PEAR channels

PKGNAMEPREFIX?=	pear-channel-

MASTER_SITES?=	#no master sites
DISTFILES?=	#no distfiles

BUILD_DEPENDS?=	${LOCALBASE}/bin/pear:${PORTSDIR}/devel/pear
RUN_DEPENDS?=	${LOCALBASE}/bin/pear:${PORTSDIR}/devel/pear

NO_BUILD?=	yes

LPEARDIR?=	share/pear

PEAR_CHANNEL_ALIAS?=	${PORTNAME}
PEAR_CHANNEL_REG?=	${FILESDIR}/${PEAR_CHANNEL_HOST}.reg

PLIST_FILES=	${LPEARDIR}/.channels/.alias/${PEAR_CHANNEL_ALIAS}.txt \
		${LPEARDIR}/.channels/${PEAR_CHANNEL_HOST}.reg \
		"@exec ${MKDIR} %D/${LPEARDIR}/.registry/.channel.${PEAR_CHANNEL_HOST}"
PLIST_DIRS=	${LPEARDIR}/.registry/.channel.${PEAR_CHANNEL_HOST}

.if !defined(PEAR_CHANNEL_HOST)
IGNORE=		Please set PEAR_CHANNEL_HOST
.elif !exists(${PEAR_CHANNEL_REG})
IGNORE=		Cannot find registry file: ${PEAR_CHANNEL_REG}
.endif

do-install:
	@${MKDIR} ${PREFIX}/${LPEARDIR}/.registry/.channel.${PEAR_CHANNEL_HOST}
	@${INSTALL_DATA} ${PEAR_CHANNEL_REG} \
		${PREFIX}/${LPEARDIR}/.channels/
	@${ECHO_CMD} -n ${PEAR_CHANNEL_HOST} > \
		${PREFIX}/${LPEARDIR}/.channels/.alias/${PEAR_CHANNEL_ALIAS}.txt
