--- F77.pm.orig	2010-12-31 19:53:06.000000000 -0600
+++ F77.pm	2011-03-24 01:05:00.742862139 -0500
@@ -351,9 +351,49 @@ $F77config{Aix}{DEFAULT}     = 'F77';
 
 ### FreeBSD ###
 
-$F77config{Freebsd}{F77}{Trail_} = 1;
-$F77config{Freebsd}{F77}{Link}   = '-L/usr/lib -lf2c -lm';
-$F77config{Freebsd}{DEFAULT}     = 'F77';
+if($^O =~ /Freebsd/i) {
+  $gfortran = 'gfortran44'; # requires rewrite
+  $fallback_compiler = 'G77';
+}
+
+$F77config{Freebsd}{G77}{Link} = sub {
+    $dir = `g77-34 -print-file-name=libg2c.a`;
+    chomp $dir;
+    # Note that -print-file-name returns just the library name
+    # if it cant be found - make sure that we only accept the
+    # directory if it returns a proper path (or matches a /)
+
+    if( defined $dir ) {
+        $dir =~ s,/libg2c.a$,,;
+    } else {
+        $dir = "/usr/local/lib";
+    }    
+    return( "-L$dir -L/usr/lib -lg2c -lm" );
+};
+
+$F77config{Freebsd}{GFortran}{Link} = sub {
+    $dir = `$gfortran -print-file-name=libgfortran.a`;
+    chomp $dir;
+    # Note that -print-file-name returns just the library name
+    # if it cant be found - make sure that we only accept the
+    # directory if it returns a proper path (or matches a /)
+
+    if( defined $dir ) {
+        $dir =~ s,/libgfortran.a$,,;
+    } else {
+        $dir = "/usr/local/lib";
+    }    
+    return( "-L$dir -L/usr/lib -lgfortran -lm" );
+};
+
+$F77config{Freebsd}{G77}{Trail_} = 1;
+$F77config{Freebsd}{GFortran}{Trail_} = 1;
+$F77config{Freebsd}{G77}{Compiler} = 'g77-34';
+$F77config{Freebsd}{GFortran}{Compiler} = "$gfortran";
+$F77config{Freebsd}{G77}{Cflags} = '-O2';
+$F77config{Freebsd}{GFortran}{Cflags}   = '-O2';
+$F77config{Freebsd}{DEFAULT}     = 'GFortran';
+
 
 ### VMS ###
 
@@ -446,7 +486,8 @@ $Pkg: Will try system=Generic Compiler=$
 EOD
     	 $system   =
             $Config{cc} =~ /\bgcc/ && $^O =~ /MSWin32/i ? "MinGW"
-                                                        :"Generic";
+                                    : $^O =~ /Freebsd/i ? "Freebsd"
+                                                        : "Generic";
     	 $compiler = $fallback_compiler;
     	 my $flibs = get ($F77config{$system}{$compiler}{Link});
     	 $Runtime =  $flibs ; #. gcclibs($flibs); #  Note gcclibs appears to be no longer required.
