/***********************************************************/
/* LIBRARY 2.00 source code copyright (c) 1993 by M. Kimes */
/*                          all rights reserved            */
/* code may not be used without prior written permission   */
/***********************************************************/

#include "doorskel.h"
#include "library.h"

/*----------------------------------------------------------------------*/
/* Info for ZOO listing                                                 */
/*----------------------------------------------------------------------*/

#define CTRL_Z     26
#define SIZ_TEXT   20                  /* Size of header text */
#define PATHSIZE   256                 /* Max length of pathname */
#define FNAMESIZE  13                  /* Size of DOS filename */
#define LFNAMESIZE 256                 /* Size of long filename */

struct zoo_header {
  char text[SIZ_TEXT];             /* archive header text */
  unsigned long zoo_tag;           /* identifies archives */
  long zoo_start;                  /* where the archive's data starts */
  long zoo_minus;                  /* consistency checking of zoo_start */
  char major_ver;
  char minor_ver;                  /* minimum ver to extract all files */
  char wuzzat;
  long comment;
  unsigned int cmt_size;
};

struct direntry {
  unsigned long zoo_tag;           /* tag -- redundancy check */
  char type;                       /* type of directory entry.
                                      always 1 for now */
  char packing_method;             /* 0 = no packing, 1 = normal LZW */
  long next;                       /* pos'n of next directory entry */
  long offset;                     /* position of this file */
  FDATE date;                      /* DOS format date */
  FTIME time;                      /* DOS format time */
  unsigned int file_crc;           /* CRC of this file */
  long org_size;
  long size_now;
  char major_ver;
  char minor_ver;                  /* minimum version needed to extract */
  char deleted;                    /* will be 1 if deleted, 0 if not */
  char struc;                      /* file structure if any */
  long comment;                    /* points to comment;  zero if none */
  unsigned int cmt_size;           /* length of comment, 0 if none */
  char fname[FNAMESIZE];           /* filename */
  int var_dir_len;                 /* len of variable part of dir entry */
  char tz;                         /* timezone where file was archived */
  unsigned int dir_crc;            /* CRC of directory entry */
  /* fields for variable part of directory entry follow */
  char namlen;                     /* length of long filename */
  char dirlen;                     /* length of directory name */
  char lfname[LFNAMESIZE];         /* long filename */
  char dirname[PATHSIZE];          /* directory name */
  int system_id;                   /* Filesystem ID */
};

/* Values for direntry.system_id */
#define SYSID_NIX       0           /* UNIX and similar filesystems */
#define SYSID_MS        1           /* MS-DOS filesystem */
#define SYSID_PORTABLE  2           /* Portable syntax */

/*-End of Zoo info------------------------------------------------------*/


int _fastcall list_zoo (word x,int printit,int justheader,char *searchfor) {

  register int      lines = 0;
  FILE              *fhandle;
  struct zoo_header main_head;
  struct direntry   one_head;
  int               result;
  char              *name;
  char              *text;
  char              *prsrh,*prsrt;
  char              ff[13];
  word              counter = 0;
  char              toggler = 0;
  char              togchar[] = "/-\\|";
  struct stat       st;

  if(!justheader) {
    if (!printit)
      free_docs();
    else {
      if(!searchfor) {
        DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
        DoorPrintf("\r\nSection #%u: %s\r\n",x + 1,section[x]);
        lines = 2;
      }
    }
    if (*section[x] == '_')
      grapharea = 1;
    else
      grapharea = 0;
  }
  strcpy(ff,section[x]);
  strcat(ff,".ZOO");
  if(stat(ff,&st)) {
    DoorPrintf("\r\nCan't find \"%s\"\r\n",ff);
    return (-1);
  }
  fhandle = DoorFsopen(ff,"rb",SH_DENYWR);
  if(!fhandle) {
    DoorPrintf("\r\nCan't open \"%s\"\r\n",ff);
    return (-1);
  }
  result = fread((char *)&main_head,1,sizeof(struct zoo_header),fhandle);
  if ((strnicmp(main_head.text,"ZOO",3)) != 0) {
    DoorPrintf("\r\nError in library file \"%s\"\r\n",ff);
    fclose(fhandle);
    return(-1);
  }
  if(printit && main_head.cmt_size) {
    text = (char *)malloc(main_head.cmt_size + 2);
    if(text) {
      fseek(fhandle,main_head.comment,SEEK_SET);
      fread((char *)text,1,main_head.cmt_size,fhandle);
      text[main_head.cmt_size] = 0;
      if(searchfor) {
        if(!DoorStristr(text,searchfor))
          goto NoHeaderMatch;
      }
      if(DoorGetGraphics()) {
        prsrh = text;
        DoorPuts(make_ansi(PC_YELLOW,PC_BLACK,NULL));
        while(prsrh && *prsrh) {
          prsrt = strchr(prsrh,'\n');
          if(prsrt) {
            *prsrt = 0;
            prsrt++;
          }
          DoorPrintf(" %s\r\n",prsrh);
          lines++;
          if(lines > DoorGetLength() - 2) {
            lines = 0;
            if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
              DoorPuts("\r\n");
              free(text);
              fclose(fhandle);
              return -1;
            }
            if(DoorGetGraphics())
              DoorPuts("\r\x1b[K\r");
            else
              DoorBackup(14);
          }
          prsrh = prsrt;
        }
      }
      else {
        prsrh = text;
        while(prsrh && *prsrh) {
          prsrt = strchr(prsrh,'\n');
          if(prsrt) {
            *prsrt = 0;
            prsrt++;
          }
          DoorPrintf(" %s\r\n",prsrh);
          lines++;
          if(lines > DoorGetLength() - 2) {
            lines = 0;
            if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
              DoorPuts("\r\n");
              free(text);
              fclose(fhandle);
              return -1;
            }
            if(DoorGetGraphics())
              DoorPuts("\r\x1b[K\r");
            else
              DoorBackup(14);
          }
          prsrh = prsrt;
        }
      }
//      lines--;
NoHeaderMatch:
      free(text);
    }
  }
  if(justheader) {
    fclose(fhandle);
    return 1;
  }
  fseek(fhandle,main_head.zoo_start,SEEK_SET);
  result = fread((char *)&one_head,sizeof(struct direntry),1,fhandle);
  if(printit && !searchfor) {
    DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
    DoorPuts("   Documents in this section:");
    if (!DoorGetGraphics())
      DoorPuts("\r\n No.   Name                                Date         Size\r\n");
    else
      DoorPuts("\r\n\x1b[0;2;33m No.   \x1b[0;1;33mName                                \x1b[0;2;33mDate         Size\x1b[0;1;34m\r\n");
    DoorPuts(" ----- --------------------------------    ----------   -------------\r\n");
    lines += 3;
  }
  do {
    if (result) {
      if(counter && !(counter%10) && !printit) {
        toggler++;
        if(toggler > 3)
          toggler = 0;
        DoorPrintf("%c\b",togchar[toggler]);
      }
      if(one_head.namlen) {
        one_head.lfname[one_head.namlen] = 0;
        if ((name = strchr(one_head.lfname,'\\')) != NULL)
          name++;
        else
          name = one_head.lfname;
      }
      else {
        if ((name = strrchr(one_head.fname,'\\')) != NULL)
          name++;
        else if ((name = strrchr(one_head.fname,'/')) != NULL)
          name++;
        else
          name = one_head.fname;
      }
      counter++;
      if(!printit)
        document[numfiles++] = strdup(name);
      else if (!searchfor || (!one_head.cmt_size && DoorStristr(name,searchfor))) {
        if(DoorGetGraphics())
          DoorPrintf("\x1b[0;2;33m %-5u \x1b[0;1;33m%-32.32s    \x1b[0;2;33m%04u/%02u/%02u   %-7ld\r\n",
                  counter,name,
                  (one_head.date.year + 1980),
                  one_head.date.month,
                  one_head.date.day,
                  one_head.org_size);
        else
          DoorPrintf(" %-5u %-32.32s    %04u/%02u/%02u   %-7ld\r\n",
                  counter,name,
                  (one_head.date.year + 1980),
                  one_head.date.month,
                  one_head.date.day,
                  one_head.org_size);
        if(++lines > DoorGetLength() - 2) {
          lines = 0;
          if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
            DoorPuts("\r\n");
            fclose(fhandle);
            return -1;
          }
          if (!DoorGetGraphics())
            DoorPuts("\r No.   Name                                Date         Size\r\n");
          else
            DoorPuts("\r\x1b[0;3;33m No.   \x1b[0;1;33mName                                \x1b[0;2;33mDate         Size\x1b[0;1;34m\r\n");
          DoorPuts(" ----- --------------------------------    ----------   -------------\r\n");
          lines = 2;
        }
      }
      if(printit && one_head.cmt_size) {
        text = (char *)malloc(one_head.cmt_size + 2);
        if(text) {
          fseek(fhandle,one_head.comment,SEEK_SET);
          fread((char *)text,one_head.cmt_size,1,fhandle);
          text[one_head.cmt_size] = 0;
          if(searchfor) {
            if(!DoorStristr(name,searchfor) && !DoorStristr(text,searchfor))
              goto NoMatch;
            if(DoorGetGraphics())
              DoorPrintf("\x1b[0;2;33m %-5u \x1b[0;1;33m%-32.32s    \x1b[0;2;33m%04u/%02u/%02u   %-7ld\r\n",
                      counter,name,
                      (one_head.date.year + 1980),
                      one_head.date.month,
                      one_head.date.day,
                      one_head.org_size);
            else
              DoorPrintf(" %-5u %-32.32s    %04u/%02u/%02u   %-7ld\r\n",
                      counter,name,
                      (one_head.date.year + 1980),
                      one_head.date.month,
                      one_head.date.day,
                      one_head.org_size);
            if(++lines > DoorGetLength() - 2) {
              lines = 0;
              if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
                DoorPuts("\r\n");
                free(text);
                fclose(fhandle);
                return -1;
              }
              if (!DoorGetGraphics())
                DoorPuts("\r No.   Name                                Date         Size\r\n");
              else
                DoorPuts("\r\x1b[0;2;33m No.   \x1b[0;1;33mName                                \x1b[0;2;33mDate         Size\x1b[0;1;34m\r\n");
              DoorPuts(" ----- --------------------------------    ----------   -------------\r\n");
              lines = 2;
            }
            DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
            prsrh = text;
            while(prsrh && *prsrh) {
              prsrt = strchr(prsrh,'\n');
              if(prsrt) {
                *prsrt = 0;
                prsrt++;
              }
              DoorPrintf("%s\r\n",prsrh);
              prsrh = prsrt;
              if(++lines > DoorGetLength() - 2) {
                lines = 0;
                if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
                  DoorPuts("\r\n");
                  free(text);
                  fclose(fhandle);
                  return -1;
                }
                if (!DoorGetGraphics())
                  DoorPuts("\r No.   Name                                Date         Size\r\n");
                else
                  DoorPuts("\r\x1b[0;2;33m No.   \x1b[0;1;33mName                                \x1b[0;2;33mDate         Size\x1b[0;1;34m\r\n");
                DoorPuts(" ----- --------------------------------    ----------   -------------\r\n");
                lines = 3;
              }
            }
          }
          else {
            prsrh = text;
            while(prsrh && *prsrh) {
              prsrt = strchr(prsrh,'\n');
              if(prsrt) {
                *prsrt = 0;
                prsrt++;
              }
              DoorPrintf("%s\r\n",prsrh);
              prsrh = prsrt;
              if(++lines > DoorGetLength() - 2) {
                lines = 0;
                if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
                  DoorPuts("\r\n");
                  free(text);
                  fclose(fhandle);
                  return -1;
                }
                if (!DoorGetGraphics())
                  DoorPuts("\r No.   Name                                Date         Size\r\n");
                else
                  DoorPuts("\r\x1b[0;2;33m No.   \x1b[0;1;33mName                                \x1b[0;2;33mDate         Size\x1b[0;1;34m\r\n");
                DoorPuts(" ----- --------------------------------    ----------   -------------\r\n");
                lines = 3;
              }
            }
          }
//          lines--;
NoMatch:
          free(text);
        }
      }
      if (printit && DoorInkey(0L) == ' ') {
        fclose(fhandle);
        return -1;
      }
      fseek(fhandle,one_head.next,SEEK_SET);
      result = fread((char *)&one_head,sizeof(struct direntry),1,fhandle);
    }
  } while ((one_head.offset) && (result) && (numfiles < MAXFILES));
  fclose(fhandle);
  if(!printit && counter >= 10)
    DoorPuts(" \b");
  if (printit) {
    if (lines > DoorGetLength() - 12) {
      lines = 0;
      DoorHitReturn();
    }
  }
  return lines;
}
