/* TM255 PROJECT  BY F5UBZ -- Emulation TS2000 --
 MikroC is the compiler
Rs232 is 4800Bds Handshake
Commands emulation are :
 FA; FB; ID; IF;

18F452 PINS :

 PORTA=  A0 (O) = DOWN
         A1 (O)= VFO A/B
         A2 (I) = PTT INPUT FOR SPLIT OPERATION ( VFO B = TX   VFO A =RX )
         A3 (I) = PTT INPUT  ( VFOA = TX = RX )
         A5 (I) = Analog input (extension)
        
 PORTB=  B[0...4] (O) = PCD3311 input A [0...4]
         B5 (O) = STROBE PCD3311
         B6 (O) = UP
         B7 (O) = PF
         
 PORTC=  C1(I)  = CTS From Computer
         C2(O) =  RTS TO Computer
         C3(I) = PTT STATUS INPUT
         C4(O)=  PTT OUT
         C5(O)= Tone switch
         C6(O)= Tx output to Computer
         C7(I)= Rx input to Computer
        
 PORTD=  D0(O)=  N/A
         D1(O)=  N/A (extension)
         D2(O)= RS To LCD
         D3(O)= E To LCD
         D[4...7] (O) =  LCD D[4...7]  4 Bits Mode
         
 PORTE=  N/A (extension)
 
 */
        

#define PF F7
#define UP F6
#define DOWN F0
#define SELECT_A_B F1
#define RTS F2
#define PTT_IN F3
#define PTT_OUT F4
#define SPLIT_ON_OFF F5
#define SWITCH_TONE F5
#define PTT_SPLIT F2
#define PTT_VFO_A F3

long VFO_A_decimal;
long consigne_A_decimal;
long VFO_B_decimal;
long consigne_B_decimal;
char VFO_A_CONSIGNE[]="144000000 ";
char VFO_B_CONSIGNE[]="144000000 ";
short j;
signed long delta ;
char txt[13];
short active_VFO ;
char tablo_IF_REPLY[]=" IF00144000000000100000000000020010000;"  ;
//                                   S              RM  S    ;
//                                   T              XO  P
//                                   E               D  L
//                                   P              TE  I
//                                                  X   T

void up_10_hertz_VFO_A(void){ Lcd_Out(1,12,"+");PORTB.UP=1;delay_ms(100); Lcd_Out(1,12," ");PORTB.UP=0 ; delay_ms(100); VFO_A_decimal++ ; }

void down_10_hertz_VFO_A(void){  Lcd_Out(1,12,"-");PORTA.DOWN=1;delay_ms(100); Lcd_Out(1,12," ");PORTA.DOWN=0 ; delay_ms(100); VFO_A_decimal-- ; }

void up_10_hertz_VFO_B(void){ Lcd_Out(2,12,"+");PORTB.UP=1;delay_ms(100); Lcd_Out(2,12," ");PORTB.UP=0 ; delay_ms(100); VFO_B_decimal++ ; }

void down_10_hertz_VFO_B(void){  Lcd_Out(2,12,"-");PORTA.DOWN=1;delay_ms(100); Lcd_Out(2,12," ");PORTA.DOWN=0 ; delay_ms(100); VFO_B_decimal-- ; }

void DTMF_out(short a) { PORTB=a ; PORTB.F4=1;PORTB.F5=1;PORTB.F5=0;  delay_ms(75) ;  PORTB=0; PORTB.F4=0;PORTB.F5=1;PORTB.F5=0;  delay_ms(75);   }

void compose_VFO_A(void) {PORTC.SWITCH_TONE=1; PORTB.PF=1;delay_ms(100);PORTB.PF=0;delay_ms(20); for (j=2;j<=6;j++) DTMF_out(VFO_A_CONSIGNE[j]-48);PORTC.SWITCH_TONE=0;}
void compose_VFO_B(void) {PORTC.SWITCH_TONE=1;PORTB.PF=1;delay_ms(100);PORTB.PF=0;delay_ms(20); for (j=2;j<=6;j++) DTMF_out(VFO_B_CONSIGNE[j]-48);PORTC.SWITCH_TONE=0;}


void compare_frequence_VFO_A(void)     {      // A VFO is active

  consigne_A_decimal=(VFO_A_CONSIGNE[2]-48) *100000 + (VFO_A_CONSIGNE[3]-48)*10000 + (VFO_A_CONSIGNE[4]-48)*1000  + (VFO_A_CONSIGNE[5]-48)*100 + (VFO_A_CONSIGNE[6]-48)*10 + (VFO_A_CONSIGNE[7]-48);
      delta=consigne_A_decimal - VFO_A_decimal;
      if ((delta<10)&&(delta>0)) {  for (j=1;j<=delta;j++) up_10_hertz_VFO_A();}
      if ((delta>-10)&&(delta<0)) {delta=-delta;for (j=1;j<=delta;j++) down_10_hertz_VFO_A();}
      if (delta<=-10) { VFO_A_decimal=(VFO_A_CONSIGNE[2]-48) *100000 + (VFO_A_CONSIGNE[3]-48)*10000 + (VFO_A_CONSIGNE[4]-48)*1000+ (VFO_A_CONSIGNE[5]-48)*100 + (VFO_A_CONSIGNE[6]-48)*10;
                       delta=(VFO_A_CONSIGNE[7]-48) ;
                       compose_VFO_A();
                       for (j=1;j<=delta;j++) up_10_hertz_VFO_A();}
      if (delta>=10) {VFO_A_decimal=(VFO_A_CONSIGNE[2]-48) *100000 + (VFO_A_CONSIGNE[3]-48)*10000 + (VFO_A_CONSIGNE[4]-48)*1000+ (VFO_A_CONSIGNE[5]-48)*100 + (VFO_A_CONSIGNE[6]-48)*10;
                      compose_VFO_A();
                      delta=(VFO_A_CONSIGNE[7]-48) ;
                      for (j=1;j<=delta;j++) up_10_hertz_VFO_A();}}
                      
void change_VFO_A_B(void) { PORTA.SELECT_A_B=1;delay_ms(100);PORTA.SELECT_A_B=0;}
                      
void compare_frequence_VFO_B(void)      // A VFO active at the end off operation
  {
      consigne_B_decimal=(VFO_B_CONSIGNE[2]-48) *100000 + (VFO_B_CONSIGNE[3]-48)*10000 + (VFO_B_CONSIGNE[4]-48)*1000  + (VFO_B_CONSIGNE[5]-48)*100 + (VFO_B_CONSIGNE[6]-48)*10 + (VFO_B_CONSIGNE[7]-48);
      delta=consigne_B_decimal - VFO_B_decimal;
      if ((delta<10)&&(delta>0)) {  change_VFO_A_B();for (j=1;j<=delta;j++) up_10_hertz_VFO_B();  change_VFO_A_B(); }
      if ((delta>-10)&&(delta<0)) {change_VFO_A_B();delta=-delta;for (j=1;j<=delta;j++) down_10_hertz_VFO_B();change_VFO_A_B();}
      if (delta<=-10) { change_VFO_A_B();
                        VFO_B_decimal=(VFO_B_CONSIGNE[2]-48) *100000 + (VFO_B_CONSIGNE[3]-48)*10000 + (VFO_B_CONSIGNE[4]-48)*1000+ (VFO_B_CONSIGNE[5]-48)*100 + (VFO_B_CONSIGNE[6]-48)*10;
                       delta=(VFO_B_CONSIGNE[7]-48) ;
                       compose_VFO_B();
                       for (j=1;j<=delta;j++) up_10_hertz_VFO_B();
                       change_VFO_A_B();}
      if (delta>=10) { change_VFO_A_B();
                      VFO_B_decimal=(VFO_B_CONSIGNE[2]-48) *100000 + (VFO_B_CONSIGNE[3]-48)*10000 + (VFO_B_CONSIGNE[4]-48)*1000+ (VFO_B_CONSIGNE[5]-48)*100 + (VFO_B_CONSIGNE[6]-48)*10;
                      compose_VFO_B();
                      delta=(VFO_B_CONSIGNE[7]-48) ;
                      for (j=1;j<=delta;j++) up_10_hertz_VFO_B();
                      change_VFO_A_B();
                      }  }

                      
    
void IF_command_reply(void) {  if (PORTC.PTT_IN==1) tablo_IF_REPLY[29]='0'; else tablo_IF_REPLY[29]='1';
                               for (j=1;j<=38;j++) Usart_Write(tablo_IF_REPLY[j]); }

void FA_command_reply(void) { Usart_Write('F');Usart_Write('A');Usart_Write('0');Usart_Write('0');Usart_Write('1');Usart_Write('4');
                              for (j=2;j<=8;j++) {Usart_Write( VFO_A_CONSIGNE[j]);}
                              Usart_Write(';');
                             }
 void FB_command_reply(void) { Usart_Write('F');Usart_Write('B');Usart_Write('0');Usart_Write('0');Usart_Write('1');Usart_Write('4');
                               for (j=2;j<=8;j++) {Usart_Write( VFO_B_CONSIGNE[j]);}
                              Usart_Write(';');
                             }



void main(void)
{
 char header[50]="--------";
 char rxchar;
 int count;
  PORTA=0;
  ADCON1=7;
  TRISA=0b11111100;
  TRISC=0b01001010;
  TRISB=0b00000000;
  PORTA=0;
  PORTB=0;
  PORTC=0;
  PORTC.RTS=1;
  Lcd_Init(&PORTD);
  LCD_Cmd(LCD_CLEAR);
  Lcd_Cmd(Lcd_CURSOR_OFF);
  Lcd_Out(1,1,"TM255 INTERFACE");
  delay_ms(2500);
  Usart_init(4800);
  count=0;
  VFO_A_decimal=0;
  VFO_B_decimal=0;
  compare_frequence_VFO_A();
  compare_frequence_VFO_B();
  delay_ms(1000);
  Lcd_Out(1,1,"PLEASE SELECT  ");
  Lcd_Out(2,1,"VFO A .        ");  delay_ms(1000);   Lcd_Out(2,1,"VFO A ..       ");  delay_ms(1000);
  Lcd_Out(2,1,"VFO A ...      ");  delay_ms(1000);   Lcd_Out(2,1,"VFO A ....     ");  delay_ms(1000);
  Lcd_Out(2,1,"VFO A .....    ");  delay_ms(1000);   Lcd_Out(2,1,"VFO A ......  ");  delay_ms(1000);  Lcd_Out(2,1,"VFO A ......... ");
  Lcd_Cmd(Lcd_Clear);
  Lcd_Out(1,13,"RX A");
  Lcd_Out(2,16,"B");
  Lcd_Chr(1,1,VFO_A_CONSIGNE[0]);Lcd_Chr_Cp(VFO_A_CONSIGNE[1]);Lcd_Chr_Cp(VFO_A_CONSIGNE[2]);Lcd_Chr_Cp('.'); Lcd_Chr_Cp(VFO_A_CONSIGNE[3]);Lcd_Chr_Cp(VFO_A_CONSIGNE[4]);
  Lcd_Chr_Cp(VFO_A_CONSIGNE[5]);Lcd_Chr_Cp('.');Lcd_Chr_Cp(VFO_A_CONSIGNE[6]);Lcd_Chr_Cp(VFO_A_CONSIGNE[7]);Lcd_Chr_Cp(VFO_A_CONSIGNE[8]);
  Lcd_Chr(2,1,VFO_B_CONSIGNE[0]);Lcd_Chr_Cp(VFO_B_CONSIGNE[1]);Lcd_Chr_Cp(VFO_B_CONSIGNE[2]);Lcd_Chr_Cp('.'); Lcd_Chr_Cp(VFO_B_CONSIGNE[3]);Lcd_Chr_Cp(VFO_B_CONSIGNE[4]);
  Lcd_Chr_Cp(VFO_B_CONSIGNE[5]);Lcd_Chr_Cp('.');Lcd_Chr_Cp(VFO_B_CONSIGNE[6]);Lcd_Chr_Cp(VFO_B_CONSIGNE[7]);Lcd_Chr_Cp(VFO_B_CONSIGNE[8]);
  PORTC.RTS=0;

  
do {   if (PORTA.PTT_VFO_A ==0)   { Lcd_Out(1,13,"TX ");
                                    PORTC.RTS=1;
                                    PORTC.PTT_OUT=1;
                                    while (PORTA.PTT_VFO_A ==0) {;}
                                    PORTC.PTT_OUT=0;
                                    delay_ms(50);
                                    Lcd_Out(1,13,"RX ");
                                    }

 if (PORTA.PTT_SPLIT==0)   {        PORTA.SELECT_A_B=1;delay_ms(100);PORTA.SELECT_A_B=0; // select B VFO
                                    delay_ms(50);
                                    Lcd_Out(1,13,"   ");
                                    Lcd_Out(2,13,"TX ");
                                    PORTC.RTS=1;
                                    PORTC.PTT_OUT=1;
                                    while (PORTA.PTT_SPLIT==0) {;}
                                    PORTC.PTT_OUT=0;
                                    Lcd_Out(1,13,"RX ");
                                    Lcd_Out(2,13,"   ");
                                    delay_ms(50);
                                    PORTA.SELECT_A_B=1;delay_ms(100);PORTA.SELECT_A_B=0; //sekect A VFO
                                    delay_ms(50);
                                    }

                                    PORTC.RTS=0;
                                    
      if   (PORTC.PTT_IN==0)   {PORTC.RTS=1; Lcd_Out(1,13,"TX"); while (PORTC.PTT_IN==0) {;}   Lcd_Out(1,13,"RX") ;PORTC.RTS=0;}
                                    

         if (Usart_Data_Ready()) {
                               rxchar = Usart_Read();
                               header[count]=rxchar;
    
                                if (rxchar=='I') {count=0;}
                                if (rxchar=='T') {count=0;}
                                if (rxchar=='R') {count=0;}
                                if ((rxchar=='F')&&(header[0]!='I')) {count=0;}
                                header[count]=rxchar;
                                count++;
                                if (count==20) count=19;

                                if ((header[0]=='I')&& (header[1]=='D')&&(header[2]==';')) {PORTC.RTS=1;
                                                                                            Usart_Write('I'); Usart_Write('D');
                                                                                            Usart_Write('0'); Usart_Write('1');
                                                                                            Usart_Write('9'); Usart_Write(';');
                                                                                            for (j=0;j<=9;j++) header[j]='-';
                                                                                             Lcd_Out(1,1,"LINK OK    ");
                                                                                             PORTC.RTS=0;
                                                                                            count=0;
                                                                                          }

                                if ((header[0]=='I')&& (header[1]=='F')&&(header[2]==';')) {  PORTC.RTS=1;
                                                                                              for (j=0;j<=9;j++) header[j]='-';
                                                                                              IF_command_reply();
                                                                                              count=0;
                                                                                              PORTC.RTS=0;
                                                                                          }

                                                                                          
                               if ((header[0]=='F')&& (header[1]=='A')&& (header[2]=='0')&&(header[3]=='0'))  {
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[0]='1';
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[1]='4';
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   if ((rxchar=='4')||(rxchar=='5')) VFO_A_CONSIGNE[2]=rxchar;                                                                                                                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[3]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[4]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[5]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[6]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[7]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[8]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[9]=rxchar;
                                                                                                   PORTC.RTS=1;
                                                                                                   for (j=0;j<=9;j++) header[j]='-';
                                                                                                   Lcd_Chr(1,1,VFO_A_CONSIGNE[0]);Lcd_Chr_Cp(VFO_A_CONSIGNE[1]);
                                                                                                   Lcd_Chr_Cp(VFO_A_CONSIGNE[2]);Lcd_Chr_Cp('.');
                                                                                                   Lcd_Chr_Cp(VFO_A_CONSIGNE[3]);Lcd_Chr_Cp(VFO_A_CONSIGNE[4]);
                                                                                                   Lcd_Chr_Cp(VFO_A_CONSIGNE[5]);Lcd_Chr_Cp('.');
                                                                                                   Lcd_Chr_Cp(VFO_A_CONSIGNE[6]);Lcd_Chr_Cp(VFO_A_CONSIGNE[7]);
                                                                                                   Lcd_Chr_Cp(VFO_A_CONSIGNE[8]);
                                                                                                   compare_frequence_VFO_A();
                                                                                                   count=0;
                                                                                                   PORTC.RTS=0;             }
                                                                                                   
                                   if ((header[0]=='F')&& (header[1]=='B')&& (header[2]=='0')&&(header[3]=='0') )  {
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[0]='1';
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[1]='4';
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   if ((rxchar=='4')||(rxchar=='5')) VFO_B_CONSIGNE[2]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[3]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[4]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[5]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[6]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[7]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_B_CONSIGNE[8]=rxchar;
                                                                                                   while (! Usart_Data_Ready()){;}
                                                                                                   rxchar= Usart_Read();
                                                                                                   VFO_A_CONSIGNE[9]=rxchar;
                                                                                                   PORTC.RTS=1;
                                                                                                   for (j=0;j<=9;j++) header[j]='-';
                                                                                                   Lcd_Chr(2,1,VFO_B_CONSIGNE[0]);Lcd_Chr_Cp(VFO_B_CONSIGNE[1]);
                                                                                                   Lcd_Chr_Cp(VFO_B_CONSIGNE[2]);Lcd_Chr_Cp('.');
                                                                                                   Lcd_Chr_Cp(VFO_B_CONSIGNE[3]);Lcd_Chr_Cp(VFO_B_CONSIGNE[4]);
                                                                                                   Lcd_Chr_Cp(VFO_B_CONSIGNE[5]);Lcd_Chr_Cp('.');
                                                                                                   Lcd_Chr_Cp(VFO_B_CONSIGNE[6]);Lcd_Chr_Cp(VFO_B_CONSIGNE[7]);
                                                                                                   Lcd_Chr_Cp(VFO_B_CONSIGNE[8]);
                                                                                                   compare_frequence_VFO_B();
                                                                                                   count=0;
                                                                                                  PORTC.RTS=0;              }
                                                                                                  
                             if ((header[0]=='F')&& (header[1]=='A')&& (header[2]==';')) {   PORTC.RTS=1;for (j=0;j<=9;j++) header[j]='-';count=0;
                                                                                              FA_command_reply(); PORTC.RTS=0; }
                                                                                              
                             if ((header[0]=='F')&& (header[1]=='B')&& (header[2]==';')) {   PORTC.RTS=1;for (j=0;j<=9;j++) header[j]='-';count=0;
                                                                                                FB_command_reply(); PORTC.RTS=0;    }
                              
                               }
                               

                                   }







  while(1);

}
